/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.mixin;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FriendlyByteBuf.class})
public class MixinPacketBuffer {
    @Inject(at={@At(value="HEAD")}, method={"writeItemStack(Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/network/FriendlyByteBuf;"}, cancellable=true, remap=false)
    public void writeItemStack(ItemStack stack, boolean limitedTag, CallbackInfoReturnable<FriendlyByteBuf> callback) {
        if (stack.m_41619_()) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            Item item = stack.m_41720_();
            this.m_130130_(Item.m_41393_((Item)item));
            this.writeByte(stack.m_41613_());
            CompoundTag compoundnbt = null;
            if (item.isDamageable(stack) || item.m_41468_()) {
                compoundnbt = limitedTag ? stack.getShareTag() : stack.m_41783_();
            }
            this.m_130079_(compoundnbt);
            CompoundTag completeNbt = new CompoundTag();
            stack.m_41739_(completeNbt);
            CompoundTag caps = completeNbt.m_128441_("ForgeCaps") ? completeNbt.m_128469_("ForgeCaps") : null;
            this.m_130079_(caps);
        }
        callback.setReturnValue((Object)((FriendlyByteBuf)FriendlyByteBuf.class.cast(this)));
        callback.cancel();
    }

    @Shadow
    public ByteBuf writeBoolean(boolean b) {
        throw new IllegalStateException("Mixin failed to shadow writeBoolean()");
    }

    @Shadow
    public FriendlyByteBuf m_130130_(int i) {
        throw new IllegalStateException("Mixin failed to shadow writeVarInt()");
    }

    @Shadow
    public ByteBuf writeByte(int i) {
        throw new IllegalStateException("Mixin failed to shadow writeByte()");
    }

    @Shadow
    public FriendlyByteBuf m_130079_(@Nullable CompoundTag nbt) {
        throw new IllegalStateException("Mixin failed to shadow writeNbt()");
    }

    @Inject(at={@At(value="HEAD")}, method={"readItem()Lnet/minecraft/world/item/ItemStack;"}, cancellable=true, remap=true)
    public void readItemStack(CallbackInfoReturnable<ItemStack> callback) {
        ItemStack result;
        if (!this.readBoolean()) {
            result = ItemStack.f_41583_;
        } else {
            int i = this.m_130242_();
            byte j = this.readByte();
            CompoundTag shareTag = this.m_130260_();
            CompoundTag capsTag = this.m_130260_();
            result = new ItemStack((ItemLike)Item.m_41445_((int)i), (int)j, capsTag);
            result.readShareTag(shareTag);
        }
        callback.setReturnValue((Object)result);
        callback.cancel();
    }

    @Shadow
    public boolean readBoolean() {
        throw new IllegalStateException("Mixin failed to shadow readBoolean()");
    }

    @Shadow
    public int m_130242_() {
        throw new IllegalStateException("Mixin failed to shadow readVarInt()");
    }

    @Shadow
    public byte readByte() {
        throw new IllegalStateException("Mixin failed to shadow readByte()");
    }

    @Shadow
    public CompoundTag m_130260_() {
        throw new IllegalStateException("Mixin failed to shadow readNbt()");
    }
}

